//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//                             example3 of ISC...                           //
//                             ------------------                           //
//                                                                          //
// - Do some background processing (just slow down forground...).           //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//                       By:- Ofer Laor (AKA LeucroTTa)                     //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#include "isc.h"   // ISC.
#include <dos.h>;  // enable, disable.

class Background: public ISC {

      virtual void isr(void);

public:
       void activate(void) {
            ISC::activate (0x8);
       }

       Background(): ISC() {};

};

void Background::isr(void)
{
    static unsigned char recursive= 0;

    old_vect();

    if (recursive)
       return;

    recursive++;

    enable();

    for (long i= 0; i< 100000; i++) {
        (*((char far *)0xb8000000L))++;
    }


    recursive--;
}



Background go; // can be either static or dynamic (not automatic- because
               //     it gets used after the program goes TSR).

int main()
{
    if (ISC::is_TSR("EXAMPLE3"))
       return 1; // too much processing in background will kill the forground.

    go.activate();

    return ISC::TSR();
}